from django.core.exceptions import ValidationError
from django.utils.translation import gettext_lazy as _

from .utils import get_domain_ip, get_valid_ips


def DomainARecoredValidator(domain):
    """Checks the domain's A record."""
    ip = get_domain_ip(domain)

    if not ip or ip not in get_valid_ips():
        raise ValidationError(
            _("Domain's ip is invalid, please check out its DNS record (A record)!"))
